/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8282;

import ibm.nways.cfgtool.CfgToolContext;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8282.DeviceView.Builder;
import ibm.nways.jdm8282.DeviceView.ChassisLike;
import ibm.nways.jdm8282.eui.ConfigurationGroup;
import ibm.nways.jdm8282.eui.FaultFolderGroup;
import ibm.nways.mib2.SystemGeneralGroup;
import ibm.nways.ras.RAS;
import ibm.nways.rping.eui.RpingBasePanel;
import ibm.nways.web.WebContext;
import java.awt.Dimension;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public class Jdm8282
extends JdmBrowser {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8282.Resources");
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private static final int RASID = 19;
    private static final int RASSUB = 13;
    private static final OID myOID = new OID("1.3.6.1.4.1.2.6.81");
    private static final String NEW_CFG_TOOL_NAME = "Conccfg.exe";
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private GenModel deviceModel;
    private boolean isDeviceUp = false;
    private boolean isDevice8282 = false;

    public String getModelTypeName() {
        return "ibm.nways.jdm8282.model.Jdm8282";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        ChassisLike chassisLike = Builder.getInstance().buildChassis(this);
        chassisLike.draw();
        return chassisLike.getGraphicPanel();
    }

    public Dimension getDefaultSize() {
        Dimension dimension = new Dimension(800, 600);
        return dimension;
    }

    protected NavigationPoint getNavTreeRoot() {
        String string = "getNavTreeRoot";
        Serializable serializable = null;
        this.deviceModel = (GenModel)this.getModel();
        if (this.deviceModel == null) {
            if (RAS.isEnabled(19, 13)) {
                RAS.trace(19, 13, (Object)this, string, "Unable to get Device Model");
            }
            this.isDeviceUp = false;
            this.isDevice8282 = false;
            this.rootFolder = new NavigationFolder(Jdm8282.getNLSString("unknown"));
            this.navContext = this.rootFolder.getNavContext();
            return this.rootFolder;
        }
        try {
            ModelInfo modelInfo = this.deviceModel.getInfo("Config");
            serializable = modelInfo.get("Config.SysObjectID");
            if (serializable instanceof Timeout || serializable instanceof NotSupported) {
                this.isDeviceUp = false;
                if (RAS.isEnabled(19, 13)) {
                    RAS.trace(19, 13, (Object)this, string, "Can't talk to the Device " + serializable.toString());
                }
            } else {
                this.isDeviceUp = true;
                this.isDevice8282 = false;
                if (serializable instanceof OID) {
                    if (RAS.isEnabled(19, 13)) {
                        RAS.trace(19, 13, (Object)this, string, "Device OID: " + serializable.toString());
                    }
                    this.isDevice8282 = myOID.equals((OID)serializable);
                }
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 13, (Object)this, string, exception);
            if (RAS.isEnabled(19, 13)) {
                RAS.trace(19, 13, (Object)this, string, "Exception getting Initial Model");
                RAS.trace(19, 13, (Object)this, string, exception.getMessage());
            }
            this.isDeviceUp = false;
            this.isDevice8282 = false;
        }
        if (RAS.isEnabled(19, 13)) {
            RAS.trace(19, 13, (Object)this, string, "Device OID: " + serializable.toString() + " " + this.isDeviceUp + this.isDevice8282);
        }
        this.rootFolder = this.isDeviceUp && this.isDevice8282 ? new NavigationFolder(Jdm8282.getNLSString("jmaTitle")) : new NavigationFolder(Jdm8282.getNLSString("unknown"));
        this.navContext = this.rootFolder.getNavContext();
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        this.displayMsg(Jdm8282.getNLSString("startTree"));
        this.tree = this.getNavigationBrowser();
        this.navContext.put((Object)"TREE", (Object)this.tree);
        this.buildConfigurationFolder(this.rootFolder);
        this.buildFaultFolder(this.rootFolder);
        this.buildToolsFolder(this.rootFolder);
        this.displayMsg(Jdm8282.getNLSString("endTree"));
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder) {
        block7: {
            GenModel genModel = null;
            ConfigurationGroup configurationGroup = null;
            String string = "buildConfigurationFolder";
            try {
                genModel = (GenModel)this.deviceModel.getComponent("Configuration");
                if (genModel == null || !this.isDeviceUp) {
                    GenModel genModel2 = null;
                    try {
                        genModel2 = (GenModel)this.deviceModel.getComponent("System");
                        if (RAS.isEnabled(19, 13)) {
                            RAS.trace(19, 13, (Object)this, string, "Got System Model = " + genModel2);
                        }
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 13, (Object)this, string, exception);
                    }
                    if (genModel2 != null) {
                        configurationGroup = new SystemGeneralGroup((JdmBrowser)this, genModel2);
                        configurationGroup.setIsInitiallyExpanded(false);
                        this.tree.addEventListener((NavigationBrowserEventListener)((SystemGeneralGroup)configurationGroup));
                        navigationFolder.add((NavigationPoint)configurationGroup);
                        return;
                    }
                    break block7;
                }
                configurationGroup = new ConfigurationGroup((JdmBrowser)this, genModel);
                configurationGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationGroup);
                navigationFolder.add((NavigationPoint)configurationGroup);
                return;
            }
            catch (RemoteException remoteException) {
                RAS.logException(19, 13, (Object)this, string, (Exception)remoteException);
            }
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildFaultFolder";
        try {
            genModel = (GenModel)this.deviceModel.getComponent("FaultFolder");
            if (genModel != null && this.isDeviceUp) {
                FaultFolderGroup faultFolderGroup = new FaultFolderGroup((JdmBrowser)this, genModel);
                faultFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)faultFolderGroup);
                navigationFolder.add((NavigationPoint)faultFolderGroup);
                return;
            }
        }
        catch (RemoteException remoteException) {
            RAS.logException(19, 13, (Object)this, string, (Exception)remoteException);
        }
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        String string = "buildToolsFolder";
        NavigationContext navigationContext = null;
        SnmpContextModel snmpContextModel = null;
        String string2 = null;
        CfgToolContext cfgToolContext = null;
        NavigationFolder navigationFolder2 = null;
        navigationFolder2 = new NavigationFolder(Jdm8282.getNLSString("ToolsGroupTitle"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder2.setIsInitiallyExpanded(true);
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            NavigationItem navigationItem;
            Object object;
            snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            string2 = modelInfo.get("Config.Address").toString();
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            Browser browser = new Browser(Jdm8282.getNLSString("mibBrowser"), (JdmBrowser)this, snmpContextModel);
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder2.add((NavigationPoint)browser.getRootFolder());
            GenModel genModel = (GenModel)this.deviceModel.getComponent("Rping");
            NavigationItem navigationItem2 = new NavigationItem(RpingBasePanel.getTitle(), new NavigationDestination("ibm.nways.rping.RpingPanel", (RemoteModel)genModel), "Rping");
            navigationFolder2.add((NavigationPoint)navigationItem2);
            WebContext webContext = new WebContext(string2);
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.web.Resources");
            webContext.support_and_device();
            NavigationItem navigationItem3 = new NavigationItem(resourceBundle.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem3.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem3);
            String string3 = System.getProperty("os.name");
            if (this.isDevice8282 && this.getIsApplication() && string3.equals("Windows NT")) {
                if (cfgToolContext == null) {
                    cfgToolContext = new CfgToolContext("8282_DEFAULT");
                    cfgToolContext.setCfgExeName(NEW_CFG_TOOL_NAME);
                }
                object = ResourceBundle.getBundle("ibm.nways.cfgtool.CfgToolGroupResources");
                navigationItem = new NavigationItem(((ResourceBundle)object).getString("cfgtoolPanelTitle"), new NavigationDestination("ibm.nways.cfgtool.CfgToolPanel", null), "CfgTool");
                navigationContext = navigationItem.getNavContext();
                navigationContext.put((Object)"cfgtoolContext", (Object)cfgToolContext);
                navigationFolder2.add((NavigationPoint)navigationItem);
            }
            if (this.getIsApplication()) {
                object = new AnalyzerJdmContext(string2, this.getServerPortNumber());
                navigationItem = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", object);
                navigationFolder2.add((NavigationPoint)navigationItem);
                return;
            }
        }
        catch (RemoteException remoteException) {
            RAS.logException(19, 13, (Object)this, string, (Exception)remoteException);
        }
    }

    public void dispose() {
        this.deviceModel = null;
        myResources = null;
        this.tree = null;
        super.dispose();
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            try {
                string2 = commonResources.getString(string);
            }
            catch (Exception exception2) {
                string2 = string;
            }
        }
        return string2;
    }
}

